function [P Prand bins] = distrReciprocal(obj,binSize,nRand)
%DISTRRECIPROCAL calculates the distribution of reciprocal connections
%   [P Prand bins] = DISTRRECIPROCAL(obj,binSize,nRand) returns a matrix P
%   whose columns represent a probability distribution of connection
%   strengths, given the connection strength of the reciprocal connection.
% 
%   Ex.:
%       input: [P Prand bins] = distrReciprocal(chem,20)
%           Then P(3,1) gives the probability that 40<=chem(j,i)<60, given
%           that 0<=chem(i,j)<20
%       
%       'bins' gives the midpoints of the bins used in calculating
%       probabilities
% 
%       Prand is the same measurement as P except it is calculated and
%       averaged over nRand random matrices as a control

switch nargin
    case 1
        binSize = 20;
        nRand = 200;
    case 2
        nRand = 200;
end

[A labels] = getSquareMatrix(obj);
nBins = ceil(max(A(:)/binSize));
P = zeros(nBins);

for i = 1:nBins
    % find the indices for A whose values are in the prescribed range
    [I J] = find((A>=((i-1)*binSize)) & (A<(i*binSize)));
    disp([I J]);
    fprintf('\n');
    % now find the values for their transpose
    idxs = sub2ind(size(A),J,I);
    for j = 1:nBins
        P(j,i) = sum((A(idxs)>=((j-1)*binSize)) & (A(idxs)<(j*binSize)));
    end
    
    % normalize by columns
    for k = 1:nBins
        P(:,k) = P(:,k)./sum(P(:,k));
    end
end
P(isnan(P)) = 0;
Prand = 0;
bins = linspace(binSize/2,(nBins-1)*binSize + binSize/2,nBins);

% image(P);

end

